------------------------------------------------------------------------
-- Event:        Delphi Day 2018, Piacenza, June 06 2018               -
--               https://www.delphiday.it/                             -
-- Seminary:     How to write high performance queries in T-SQL        -
-- Demo:         UNPIVOT                                               -
-- Author:       Sergio Govoni                                         -
-- Notes:        --                                                    -
------------------------------------------------------------------------


USE [WideWorldImporters];
GO


SELECT * FROM Sales.TempDDay18;
GO

-- L'obiettivo  creare una riga per cliente e anno contenente:
-- il riferimento al cliente, l'anno e il totale documento

-- Step 1: Create 12 copie (2004 - 2018) della stessa riga "base"
-- utilizzo l'operatore CROSS JOIN tra la tabella di base ed una
-- tabella ausiliaria che ha una riga per anno


-- Unpivoting, senza l'utilizzo dell'operatore UNPIVOT
SELECT *
FROM (SELECT CustomerID, Years.OrderYear,
        CASE Years.OrderYear
	      WHEN 2010 THEN [2010]
	      WHEN 2011 THEN [2011]
	      WHEN 2012 THEN [2012]
	      WHEN 2013 THEN [2013]
	      WHEN 2014 THEN [2014]
	      WHEN 2015 THEN [2015]
	      WHEN 2016 THEN [2016]
	      WHEN 2017 THEN [2017]
	      WHEN 2018 THEN [2018]
	    END AS TotalDue
	  FROM Sales.TempDDay18
      CROSS JOIN
        (SELECT 2010 AS OrderYear
         UNION ALL SELECT 2011
         UNION ALL SELECT 2012
         UNION ALL SELECT 2013
         UNION ALL SELECT 2014
         UNION ALL SELECT 2015
         UNION ALL SELECT 2016
         UNION ALL SELECT 2017
         UNION ALL SELECT 2018
        ) AS Years) AS D
WHERE
  D.TotalDue IS NOT NULL;
GO


-- Unpivoting con utilizzo dell'operatore UNPIVOT
SELECT
  CustomerID
  ,OrderYear
  ,TotalDue
FROM
  Sales.TempDDay18
UNPIVOT
  (
    TotalDue FOR OrderYear
    IN ([2010], [2011], [2012], [2013], [2014], [2015], [2016], [2017], [2018])
  ) AS U;
GO